#!/bin/sh
set -o errexit
echo 'Please keep this window open until the installation is completed. If any error appears, please rerun the script.'
if [ -d "tomcat/" ];then
  rm -rf tomcat
fi
read -p "Input tomcat-8.5 folder path(e.g. ~/Desktop/apache-tomcat-8.5.45), then click Enter: " tomcatPath
mkdir tomcat
cp -r "$tomcatPath/" tomcat/
if [ ! -f "tomcat/bin/startup.sh" ];then
  echo "tomcat path is invalid. Should have a bin folder under the path."
  exit
fi
if [[ `uname -a` == Darwin* ]]; then
  read -p "Input jre folder path(e.g. ~/Desktop/jre1.8.0_131.jre), then click Enter: " jrePath
  if [ -d "tomcat/jre/" ];then
    rm -rf tomcat/jre
  fi
  mkdir tomcat/jre/
  cp -r "$jrePath/" tomcat/jre/
  if [ ! -d "tomcat/jre/Contents" ];then
  echo "jre path is invalid. Should have a Contents folder under the path."
  exit
fi
  sed -i '' '1 a\
  JRE_HOME=../jre/Contents/Home
  ' tomcat/bin/setclasspath.sh
  sed -i '' 's/8080/3302/' tomcat/conf/server.xml
fi
if [[ `uname -a` == Linux* ]]; then
  read -p "Input jre folder path, then click Enter: " jrePath
  mkdir tomcat/jre/
  cp -r "$jrePath/" tomcat/jre/
  sed '1i JRE_HOME=../jre' tomcat/bin/setclasspath.sh
  sed -i 's/8080/3302/' tomcat/conf/server.xml
fi
cp MxgraphBackend.war tomcat/webapps/
cp DocGenMicroService.war tomcat/webapps/
chmod +x tomcat/bin/*.sh
chmod +x ca-offline-macos
chmod +x run.sh
xattr -cr .
echo 'Installed the application successfully. You can input "sh run.sh" to run the application.'
