echo 'Please keep this window open until the installation is completed. If any error appears, please rerun the script.'
$CurrentyDir = Split-Path -Parent $MyInvocation.MyCommand.Definition
$tomcatPath = Read-Host "Input tomcat-8.5 folder path(e.g. ~/Desktop/apache-tomcat-8.5.45), then click Enter"
if (!(Test-Path "$tomcatPath/bin/startup.bat")) {
    echo "tomcat path is invalid. Should have a bin folder under the path. Please rerun the script."
    Read-Host | Out-Null ;
    Exit
}
cp -R -force "$tomcatPath/" tomcat/
$jrePath = Read-Host "Input jre folder path(e.g. ~/Desktop/jre1.8.0_131), then click Enter"
if (!(Test-Path "$jrePath/bin/java.exe")) {
    echo "jre path is invalid. Should have a bin folder under the path. Please rerun the script."
    Read-Host | Out-Null ;
    Exit
}
cp -R -force "$jrePath/" tomcat/jre/
(type 'tomcat/conf/server.xml') -replace ('8080','3302')|Out-File -Encoding utf8 tomcat/conf/server.xml
cp -force MxgraphBackend.war tomcat/webapps/
cp -force DocGenMicroService.war tomcat/webapps/
echo "Installed the application successfully. You can close the window and run run.bat (e.g. by double clicking the file) to start the application."
Read-Host | Out-Null ;
Exit
